<?php
$CI = get_instance();
$CI->load->database();
$CI->load->dbforge();

$field1 = array(
    'id' => array(
        'type' => 'INT',
        'constraint' => 11,
        'unsigned' => TRUE,
        'auto_increment' => TRUE,
        'collation' => 'utf8_unicode_ci'
    ),
    'lesson_id' => array(
        'type' => 'INT',
        'constraint' => '11',
        'default' => null,
        'null' => TRUE,
        'collation' => 'utf8_unicode_ci'
    ),
    'title' => array(
        'type' => 'VARCHAR',
        'constraint' => '255',
        'default' => null,
        'null' => TRUE,
        'collation' => 'utf8_unicode_ci'
    ),
    'file_name' => array(
        'type' => 'VARCHAR',
        'constraint' => '255',
        'default' => null,
        'null' => TRUE,
        'collation' => 'utf8_unicode_ci'
    ),
    'created_at' => array(
        'type' => 'VARCHAR',
        'constraint' => '255',
        'default' => null,
        'null' => TRUE,
        'collation' => 'utf8_unicode_ci'
    ),
    'updated_at' => array(
        'type' => 'VARCHAR',
        'constraint' => '255',
        'default' => null,
        'null' => TRUE,
        'collation' => 'utf8_unicode_ci'
    )
);
$CI->dbforge->add_field($field1);
$CI->dbforge->add_key('id', TRUE);
$attributes = array('collation' => "utf8_unicode_ci");
$CI->dbforge->create_table('resource_files', TRUE);


$frontend_settings_css = array(
    'key' => 'custom_css',
    'value' => ''
);
$CI->db->insert('frontend_settings', $frontend_settings_css);

$frontend_settings_embed = array(
    'key' => 'embed_code',
    'value' => ''
);
$CI->db->insert('frontend_settings', $frontend_settings_embed);

$notification_settings = array(
    'type' => 'noticeboard',
    'is_editable' => '1',
    'addon_identifier' => 'noticeboard',
    'user_types' => '["student"]',
    'system_notification' => '{"student":"1"}',
    'email_notification' => '{"student":"1"}',
    'subject' => '{"student":"Noticeboard"}',
    'template' => '{"student":"Hi, You have a new notice by [instructor_name]. The course [course_title] [notice_title][notice_description]"}',
    'setting_title' => 'Course Noticeboard',
    'setting_sub_title' => 'Notify to enrolled students when announcements are created by the instructor for a particular course.',
    'date_updated' => '1699525375'
);
$CI->db->insert('notification_settings', $notification_settings);

// update VERSION NUMBER INSIDE SETTINGS TABLE
$settings_data = array('value' => '6.4');
$CI->db->where('key', 'version');
$CI->db->update('settings', $settings_data);